{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{phang}
{bf:dsimih describe} {hline 2} Describe {cmd:svarih} results and associated dynamic simulation results created by {cmd:dsimih}


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:dsimih} {cmdab:d:escribe} [{help using} {it:filename}] [{cmd:,} {it:options}]

{marker options_table}{...}
{synoptset 16 tabbed}{...}
{synopthdr}
{synoptline}
{synopt:{opt m:odelstats}}display basic features of the estimated {cmd:svarih} model{p_end}
{synopt:{opt c:mdline}}display the command that was used to obtain {cmd:svarih} estimates{p_end}
{synopt:{opt nost:ep}}do not display availability of forecast steps{p_end}
{synopt:{opt b:ootstrap}}displays information on the success and failure of bootstrap replications{p_end}
{synopt:{opt a:ll}}shortcut to specify options {opt modelstats}, {opt cmdline}, and {opt bootstrap}{p_end}
{synopt:{opt n:umber(#)}}access results number {it:#} ; only allowed if the {cmd:using} modifier refers to a {cmd:.ster} file{p_end}
{synoptline}
{p2colreset}{...}

{marker description}{...}
{title:Description}

{pstd}
{cmd:dsimih describe} lists the forecast horizons/steps of dynamic simulation results created by {help dsimih create}.
It also displays relevant properties of the underlying estimated {cmd:svarih} model.

{pstd}
{cmd:dsimih describe} defaults to displaying the forecast steps available, by regime and type of standard error.
More information can be accessed by using the options of the command.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation, syntax elements}

{pstd}
This help entry uses terminology defined in {help svarih##abbreviations:svarih} and {help dsimih##abbreviations:dsimih}.


{marker options}{...}
{title:Options}

{phang}
{opt m:odelstats} displays properties of the underlying {cmd:svarih} model that are relevant for the creation of dynamic simulation statistics.

{pmore}
The first set of properties displayed concerns whether the {cmd:svarih} estimation has converged, how many GLS iterations were carried out (if applicable), and whether estimates are locally identified (if applicable).
Moreover, information on the size of the model is displayed like the number of endogenous variables, the number of lags, and the maximum lag.
As a rule of thumb, the "larger" the model the longer it takes to obtain {cmd:svarih} estimates, and the longer it takes to run {cmd:dsimih} with its bootstrap options {opt bs} and {opt bsp}.
The size of the model may also be relevant for the time it takes to generate asymptotic DS standard errors since this too may become computationally intensive for long forecast horizons.

{phang}
{opt c:mdline} displays the command that was used to run {cmd:svarih}.

{phang}
Options {opt modelstats} and {opt cmdline} are especially helpful if you choose to or if you are forced to save {cmd:dsimih} results in {help dsimih_etodta##dsimihfiles:dsimih files} rather than in {cmd:e()}.
If you save your results in {cmd:e()}, they are firmly associated with the underlying {cmd:svarih} estimates and you can always recover all details of estimation from the {cmd:e()}-results saved by {cmd:svarih}.
Here {opt modelstats} and {opt cmdline} are merely convenience tools that allow you to check the most important features quickly.
If you save your results in {cmd:dsimih files}, the {cmd:e()}-results of {cmd:svarih} are no longer available.
{cmd:dsimih} therefore records selected features of the {cmd:svarih} estimation within these files.
This information can be accessed via options {opt modelstats} and {opt cmdline}.

{phang}
{opt nost:ep} will not tabulate the availability of forecast steps.

{phang}
{opt b:ootstrap} displays information on the estimation of bootstrapped DS standard errors, if any exist.
Separate tables for the residual bootstrap and for the parametric bootstrap are shown.
They contain detail about the number of successful bootstrap replications and about the ones that failed.

{phang}
{opt a:ll} is a shortcut for specifying options {opt modelstats}, {opt cmdline}, and {opt bootstrap}.
{opt a:ll} overrides the usage of any other options.
For example, if option {opt nostep} is used in addition to {opt all}, it is ignored.

{phang}
{opt number(#)} specifies the results set number when the {cmd:using} modifier refers to a {cmd:.ster} file.
You can store more than one results set in {cmd:.ster} files.
See {help estimates save}.

{marker remarks}{...}
{title:Remarks}

{pstd}
{cmd:dsimih describe} by default accesses DS results in {cmd:e()} but is also capable of accessing DS results stored in files using its {opt using} modifier.
For details on how the {opt using} modifier works in all {cmd:dsimih} subcommands, see {help dsimih_etodta##theusingmodifier:dsimih etodta}.

{pstd}
Forecast horizons are tabulated by regime and {it:setype}.

{pstd}
By default, {cmd:dsimih describe} looks in {cmd:e()} for results left behind by {cmd:dsimih create}.
If {it:filename} is specified, {cmd:dsimih describe} describes the results stored in {it:filename}.
{it:filename} must be a {cmd:dsimih file}.
As detailed in {help dsimih etodta}, you may not change the data in these files.
You must specify {it:filename} if {cmd:e()} does not contain results from {cmd:dsimih create}.
Remember that {cmd:dsimih describe} describes either results in {cmd:e()} or in {it:filename}, but never the data set in memory.

{marker examples}{...}
{title:Examples}

{pstd}
Excecuting the following statements will change current {cmd:e()}-results.

{pstd}
Bootstrap replication numbers are set to values that are inappropriate for analysis but appropriate for quick execution of example statements.

{pstd}
Generate example estimates (see {help svarih examples}):

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples bfa_unconstr , ereplace:. svarih examples bfa_unconstr , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats cmdline:. dsimih describe , modelstats cmdline}{p_end}

{phang2}{stata dsimih create , step(24):. dsimih create , step(24)}{p_end}
{phang2}{stata dsimih create , step(36) nose:. dsimih create , step(36) nose}{p_end}
{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , step(12) bsp fromb reps(10):. dsimih create , step(12) bsp fromb reps(10)}{p_end}

{pstd}
By default, {dsimih describe} tabulates the forecast horizon by regime and {it:setype}:

{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
All information that is requested by the options of {cmd:dsimih describe} is stored in {cmd:r()}.

{phang2}{stata return list:. return list}{p_end}
{phang2}{stata matrix list r(stepmat):. matrix list r(stepmat)}{p_end}
{phang2}{stata dsimih describe , bootstrap nostep:. dsimih describe , bootstrap nostep}{p_end}
{phang2}{stata return list:. return list}{p_end}
{phang2}{stata matrix list r(repmat_bsp):. matrix list r(repmat_bsp)}{p_end}

{pstd}
{cmd:dsimih describe} works with both {opt .ster} files and {help dsimih_etodta##dsimihfiles:dsimih files}.

{phang2}{stata estimates save dsimih_examplefile , replace:. estimates save dsimih_examplefile , replace}{p_end}
{phang2}{stata ereturn clear:. ereturn clear}{p_end}
{phang2}{stata dsimih describe using dsimih_examplefile.ster , bootstrap:. dsimih describe using dsimih_examplefile.ster , bootstrap}{p_end}

{phang2}{stata estimates use dsimih_examplefile:. estimates use dsimih_examplefile}{p_end}
{phang2}{stata dsimih etodta dsimih_examplefile2 , replace:. dsimih etodta dsimih_examplefile2 , replace}{p_end}
{phang2}{stata ereturn clear:. ereturn clear}{p_end}
{phang2}{stata dsimih describe using dsimih_examplefile2.dta , bootstrap:. dsimih describe using dsimih_examplefile2.dta , bootstrap}{p_end}

{phang2}{stata erase dsimih_examplefile.ster:. erase dsimih_examplefile.ster}{p_end}
{phang2}{stata erase dsimih_examplefile2.dta:. erase dsimih_examplefile2.dta}{p_end}


{marker savedresults}{...}
{title:Saved results}

{pstd}
{cmd:dsimih describe} saves the following in {cmd:r()}.
Some of the results below may not be saved if they are not applicable to the {cmd:svarih} model in question.


{pmore}
If option {opt modelstats} is used or implied by option {opt all}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 0:Scalars}{p_end}
{synopt:{cmd:r(converged_ml)}}{cmd:1} if the ML iteration converged, {cmd:0} otherwise{p_end}
{synopt:{cmd:r(converged_gls)}}{cmd:1} if the GLS iteration converged, {cmd:0} otherwise{p_end}
{synopt:{cmd:r(ic_gls)}}# of GLS iterations performed{p_end}
{synopt:{cmd:r(mlag)}}maximum lag in the model{p_end}
{synopt:{cmd:r(Wald_p)}}probability for minimium Wald statistic for IH-LLU global identification check{p_end}
{synopt:}{p_end}
{p2col 5 20 24 0:Macros}{p_end}
{synopt:{cmd:r(method)}}{cmd:svarih} method (subcommand){p_end}
{synopt:{cmd:r(depvar)}}list of endogenous variables in the model{p_end}
{synopt:{cmd:r(regimes)}}regimes of the {cmd:svarih} model{p_end}
{synopt:{cmd:r(lags)}}list of lags in the model{p_end}
{synopt:{cmd:r(exog)}}exogenous variables in the model, if any{p_end}
{synopt:{cmd:r(idencheck)}}one of {cmd:passed}, {cmd:failed}, or {cmd:skipped}{p_end}
{p2colreset}{...}


{pmore}
If option {opt cmdline} is used or implied by option {opt all}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 0:Macros}{p_end}
{synopt:{cmd:r(cmdline)}}command as typed in {cmd:svarih} estimation{p_end}
{p2colreset}{...}


{pmore}
If option {opt nostep} is not used or if option {opt all} is used

{synoptset 20 tabbed}{...}
{p2col 5 20 24 0:Macros}{p_end}
{synopt:{cmd:r(stepmat_regimes)}}list of regimes for which dynamic simulation results exist{p_end}
{synopt:}{p_end}
{p2col 5 20 24 0:Matrices}{p_end}
{synopt:{cmd:r(stepmat)}}forecast steps available, by regimes and {it:setype}{p_end}
{p2colreset}{...}


{pmore}
If option {opt bootstrap} is used or implied by option {opt all}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 0:Matrices}{p_end}
{synopt:{cmd:r(repmat_bs)}}information on success and failure of replications of the residual bootstrap{p_end}
{synopt:{cmd:r(repmat_bsp)}}information on success and failure of replications of the parametric bootstrap{p_end}
{p2colreset}{...}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih},
{helpb dsimih create},
{helpb dsimih graph},
{helpb dsimih table},
{helpb dsimih use},
{helpb dsimih drop},
{helpb dsimih etodta}
{p_end}


